<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>Edit Produk - Salon Nizam</title>
    <link href="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/style.min.css" rel="stylesheet" />
    <link href="css/styles.css" rel="stylesheet" />
    <script src="https://use.fontawesome.com/releases/v6.3.0/js/all.js" crossorigin="anonymous"></script>
</head>

<body class="sb-nav-fixed">
    <?php include("header.php"); ?>
    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <?php include("sidebar.php"); ?>
        </div>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid px-4">
                    <h1 class="mt-4">Edit Produk Shampoo</h1>
                    <br>
                    <?php
                    $mysqli = new mysqli("localhost", "root", "", "salon_nizam");

                    if ($mysqli->connect_error) {
                        die("Koneksi gagal: " . $mysqli->connect_error);
                    }

                    if (isset($_GET['id'])) {
                        $id = intval($_GET['id']);
                        $result = $mysqli->query("SELECT * FROM shampoo WHERE id = $id");

                        if ($result->num_rows > 0) {
                            $row = $result->fetch_assoc();
                        } else {
                            echo "<div class='alert alert-danger'>Produk tidak ditemukan.</div>";
                            exit;
                        }
                    } else {
                        echo "<div class='alert alert-danger'>ID tidak valid.</div>";
                        exit;
                    }
                    ?>

                    <div class="col-md-12">
                        <div class="container">
                            <form action="update_produk.php" method="POST" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="<?php echo $row['id']; ?>">

                                <div class="form-group">
                                    <label for="nama_shampoo">Nama Shampoo:</label>
                                    <input type="text" class="form-control" id="nama_shampoo" name="nama_shampoo"
                                        value="<?php echo htmlspecialchars($row['nama_shampoo']); ?>" required>
                                </div>
                                <br>
                                <div class="form-group">
                                    <label for="harga">Harga:</label>
                                    <input type="number" step="0.01" class="form-control" id="harga" name="harga"
                                        value="<?php echo $row['harga']; ?>" required>
                                </div>
                                <br>
                                <div class="form-group">
                                    <label for="foto">Foto Produk (Biarkan kosong jika tidak ingin mengubah
                                        foto):</label>
                                    <input type="file" class="form-control-file" id="foto" name="foto">
                                    <br>
                                    <img src="uploads/<?php echo $row['foto']; ?>"
                                        alt="<?php echo $row['nama_shampoo']; ?>"
                                        style="width: 100px; margin-top: 10px;">
                                </div>
                                <br>
                                <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                                <a href="produk.php" class="btn btn-secondary">Kembali</a>
                            </form>
                        </div>
                    </div>
                </div>
            </main>
            <footer class="py-4 bg-light mt-auto">
                <div class="container-fluid px-4">
                    <div class="d-flex align-items-center justify-content-between small">
                        <div class="text-muted">Copyright &copy; Salon Nizam 2023</div>
                        <div>
                            <a href="#">Privacy Policy</a>
                            &middot;
                            <a href="#">Terms &amp; Conditions</a>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous">
    </script>
    <script src="js/scripts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
    <script src="assets/demo/chart-area-demo.js"></script>
    <script src="assets/demo/chart-bar-demo.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js"
        crossorigin="anonymous"></script>
    <script src="js/datatables-simple-demo.js"></script>
</body>

</html>