<?php
// Koneksi ke database
$mysqli = new mysqli("localhost", "root", "", "salon_nizam");

// Periksa koneksi
if ($mysqli->connect_error) {
    die("Koneksi database gagal: " . $mysqli->connect_error);
}

// Periksa apakah parameter ID tersedia di URL
if (isset($_GET['id'])) {
    // Ambil ID produk yang akan dihapus
    $id = $_GET['id'];

    // Query untuk mengambil data produk berdasarkan ID
    $query = "SELECT foto FROM shampoo WHERE id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    // Periksa apakah produk ditemukan
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $foto = $row['foto'];

        // Hapus file foto dari folder 'uploads'
        if (file_exists($foto)) {
            unlink($foto);
        }

        // Query untuk menghapus data produk
        $deleteQuery = "DELETE FROM shampoo WHERE id = ?";
        $deleteStmt = $mysqli->prepare($deleteQuery);
        $deleteStmt->bind_param("i", $id);

        if ($deleteStmt->execute()) {
            echo "<script>alert('Produk berhasil dihapus.'); window.location='produk.php';</script>";
        } else {
            echo "<script>alert('Gagal menghapus produk.'); window.location='produk.php';</script>";
        }
    } else {
        echo "<script>alert('Produk tidak ditemukan.'); window.location='produk.php';</script>";
    }

    $stmt->close();
} else {
    echo "<script>alert('ID produk tidak valid.'); window.location='admin_produk.php';</script>";
}

// Tutup koneksi database
$mysqli->close();
?>